#!/system/bin/sh

case $1 in 
    480p)
        fbset -fb /dev/graphics/fb0 -g 720 480 720 960 16 -rgba 5/11,6/5,5/0,0/0
        echo $1 > /sys/class/display/mode
    ;;

    720p)
        fbset -fb /dev/graphics/fb0 -g 800 1280 800 2560 32 -rgba 5/11,6/5,5/0,0/0
        echo $1 > /sys/class/display/mode
        echo 0 0 1280 800 0 0 32 32 > /sys/class/display/axis
    ;;

    1080p)
        fbset -fb /dev/graphics/fb0 -g 800 1280 800 2560 32 -rgba 5/11,6/5,5/0,0/0
        echo $1 > /sys/class/display/mode
        echo	0 0 1280 800 0 0 32 32 > /sys/class/display/axis
    ;;

    panel)
        fbset -fb /dev/graphics/fb0 -g 800 1280 800 2560 32
        fbset -fb /dev/graphics/fb1 -g 32 32 32 32 32
        echo $1 > /sys/class/display/mode
        echo 0 0 800 1280 0 0 32 32 > /sys/class/display/axis
	fbset -fb /dev/graphics/fb2 -g 1280 720 1280 1440 32
        echo null > /sys/class/display2/mode
        echo 0 0 1280 720 > /sys/class/display2/axis
	echo 3 > /sys/class/ppmgr/platform_type		
    ;;
    
    *)
        echo "Error: Un-supported display mode $1"
        echo "       Default to panel"
        fbset -fb /dev/graphics/fb0 -g 1280 800 1280 1600 32
        fbset -fb /dev/graphics/fb1 -g 32 32 32 32 32
        echo $1 > /sys/class/display/mode
        echo 0 0 1280 800 0 0 32 32 > /sys/class/display/axis
esac
