# -*- encoding: utf-8 -*-

import plugintest
from basePlugin import *
import re


class MyPlugin(BasePlugin):
    LOGPREFIX = "my-test-prefix:"

    @plugin_folder
    def root(self):
        self.log('msg info')
        self.debug('msg debug')
        self.warning('msg warn')
        self.error('msg err')
        return [
                PFolder(label=u'Kočka'),
                PFolder(label='bb', menuItems=[('label','action')]),
            ]

    @plugin_folder
    def empty(self):
        pass

    @plugin_folder
    def myGen(self):
        self.core.setSorting(None)
        yield PItem(label='x')
        yield PItem(label='y')

    @plugin_call
    def p1(self, url=None, info=None):
        self.core.play(url, info)

    @plugin_folder
    def cancel(self):
        yield PItem(label='1')
        raise CancelOperation()
        yield PItem(label='2')

    @plugin_folder
    def okdialog(self):
        if self.core.okDialog('Cancel test', 'L1', 'LL2', 'LLL3'):
            yield PItem('ok')
        else:
            yield PItem('cancel')


    @plugin_folder
    def textdialog(self):
        txt = self.core.textDialog('head', 'dflt')
        if txt is not None:
            yield PItem(txt)
        else:
            yield PItem('NONE')


    def no_call(self):
        pass


class TestBasePlugin(plugintest.PluginTestCase):
    PLUGIN_CLASS = MyPlugin

    def test_constructor(self):
        self.assertEqual(self.plugin.core, self.iface)
        self.assertTrue(self.plugin.wget)


    def test_value_matches(self):
        self.assertTrue( plugintest.value_matches(1, 1) )
        self.assertTrue( plugintest.value_matches(-1.310, -1.310) )
        self.assertTrue( plugintest.value_matches('asdd33', 'asdd33') )
        self.assertTrue( plugintest.value_matches([2,3,7], [2,3,7]) )
        self.assertTrue( plugintest.value_matches({'xx': '33', 7:8},
                                                  {'xx': '33', 7:8}) )

        self.assertFalse( plugintest.value_matches(1, '1') )
        self.assertFalse( plugintest.value_matches('1', 1) )
        self.assertFalse( plugintest.value_matches([2,3,7, 1], [2,3,7]) )
        self.assertFalse( plugintest.value_matches({'xx': '333', 7:8},
                                                  {'xx': '33', 7:8}) )

        self.assertTrue( plugintest.value_matches('x asd x', re.compile('asd')) )
        self.assertTrue( plugintest.value_matches('asd x', re.compile('^asd')) )
        self.assertTrue( plugintest.value_matches('x asd', re.compile('asd$')) )
        self.assertTrue( plugintest.value_matches('1', re.compile('1')) )

        self.assertFalse( plugintest.value_matches('x asd', re.compile('^asd')) )
        self.assertFalse( plugintest.value_matches(1, re.compile('1')) )


    def test_pitem_unmatches(self):
        item = PItem(label = 'My mock label',
                     call = 'test-call',
                     param = {'path': '/test/first'},
                     info  = {'title': 'aaa 353', 'rating': 1.5},
                )
        self.assertEqual( plugintest.pitem_unmatches(item,
                            label='My mock label',
                            info={'rating': 1.5}
                        ), [] )
        self.assertEqual( plugintest.pitem_unmatches(item,
                            label=re.compile('^My'),
                            info={'title': re.compile('^aaa')}
                        ), [] )

        self.assertEqual( plugintest.pitem_unmatches(item,
                            label='My mock label',
                            info={'aaa': 5353, 'rating': '1.5'},
                            call='test-call-2'
                        ), [
                            "item.call does not match 'test-call-2'",
                            'item.info[aaa] does not exist',
                            "item.info[rating] does not match '1.5'"
                        ] )


    def test_assertPItemMatches(self):
        item = PItem(label = 'My mock label',
                     call = 'test-call',
                     param = {'path': '/test/first'},
                     info  = {'title': 'aaa 353', 'rating': 1.5},
                )

        self.assertPItemMatches(item, label='My mock label')
        self.assertPItemMatches(item, label=re.compile('^My mock'),
                                        info={'rating': 1.5})
        try:
            self.assertPItemMatches(item, label='aax',
                                        info={'rating': 1.2})
        except self.failureException, e:
            self.assertEqual(str(e), "item.info[rating] does not match 1.2\n"
                                        +"item.label does not match 'aax'\n"
                                        +"item: "+repr(item))
        else:
            self.assertFalse('FAILED')


    def test_assertItemExists(self):
        self.iface.ITEMS = [
                PItem(label='AAA', info={'rating': 2.7}),
                PItem(label='BBB', info={'rating': 1.1}),
                PItem(label='CCC', info={}),
                PItem(label='DDDDD'),
            ]

        item = self.assertPItemExists(label='AAA')
        self.assertEqual(item.label, 'AAA')

        item = self.assertPItemExists(info={'rating': 1.1})
        self.assertEqual(item.label, 'BBB')

        item = self.assertPItemExists(label=re.compile('^\w{3}'))
        self.assertEqual(item.label, 'AAA')

        item = self.assertPItemExists(label=re.compile('^\w{5}'))
        self.assertEqual(item.label, 'DDDDD')

        try:
            self.assertPItemExists(label=re.compile('\d'))
        except self.failureException, e:
            self.assertEqual(str(e), "PItem not found")
        else:
            self.assertFalse('FAILED')


    def test_PItem_1(self):
        pi = PItem('my-lbl')
        self.assertTrue(isinstance(pi, PItem))
        self.assertEqual(pi.label, 'my-lbl')
        self.assertEqual(pi.call, None)
        self.assertEqual(pi.param, {})
        self.assertEqual(pi.info, {})
        self.assertEqual(pi.isFolder, False)
        self.assertEqual(pi.iconURL, None)
        self.assertEqual(pi.type, 'video')
        self.assertEqual(pi.path, None)
        self.assertEqual(repr(pi), "<PItem label='my-lbl' call=None param={} info={} type='video'>")


    def test_PItem_2(self):
        pi = PItem(label='7 x', label2='2x', call='ax',
                    param={2:3}, info={'x':35},
                    isFolder=1, iconURL='ax.jpg',
                    type='music', path='http://asdx',
                )
        self.assertTrue(isinstance(pi, PItem))
        self.assertEqual(pi.label, '7 x')
        self.assertEqual(pi.label2, '2x')
        self.assertEqual(pi.call, 'ax')
        self.assertEqual(pi.param, {2: 3})
        self.assertEqual(pi.info, {'x': 35})
        self.assertEqual(pi.isFolder, True)
        self.assertEqual(pi.iconURL, 'ax.jpg')
        self.assertEqual(pi.type, 'music')
        self.assertEqual(pi.path, 'http://asdx')
        self.assertEqual(repr(pi), "<PItem label='7 x' label2='2x' call='ax'"
                                    +" param={2: 3} info={'x': 35} isFolder"
                                    +" iconURL='ax.jpg' path='http://asdx'"
                                    +" type='music'>")


    def test_PFolder_1(self):
        PItem.DEFAULT_TYPE = 'xyz-type'
        try:
            pi = PFolder('my-label')
            self.assertTrue(isinstance(pi, PItem))
            self.assertEqual(pi.label, 'my-label')
            self.assertEqual(pi.label2, None)
            self.assertEqual(pi.call, None)
            self.assertEqual(pi.param, {})
            self.assertEqual(pi.info, {})
            self.assertEqual(pi.isFolder, True)
            self.assertEqual(pi.iconURL, None)
            self.assertEqual(pi.type, 'xyz-type')
            self.assertEqual(pi.path, None)
            self.assertEqual(repr(pi), "<PItem label='my-label' call=None param={} info={} isFolder type='xyz-type'>")
        finally:
            PItem.DEFAULT_TYPE = 'video'


    def test_PFolder_2(self):
        pi = PFolder(label='7 x', label2='2x', call='ax',
                    param={2:3}, info={'x':35},
                    isFolder=0, iconURL='ax.jpg',
                    type='music', path='JkkL'
                )
        self.assertTrue(isinstance(pi, PItem))
        self.assertEqual(pi.label, '7 x')
        self.assertEqual(pi.label2, '2x')
        self.assertEqual(pi.call, 'ax')
        self.assertEqual(pi.param, {2: 3})
        self.assertEqual(pi.info, {'x': 35})
        self.assertEqual(pi.isFolder, True)
        self.assertEqual(pi.iconURL, 'ax.jpg')
        self.assertEqual(pi.type, 'music')
        self.assertEqual(pi.path, 'JkkL')
        self.assertEqual(repr(pi), "<PItem label='7 x' label2='2x' call='ax'"
                                    +" param={2: 3} info={'x': 35} isFolder"
                                    +" iconURL='ax.jpg' path='JkkL'"
                                    +" type='music'>")


    def test_root(self):
        self.plugin.call()
        self.assertEqual(self.iface.LOG,
                ['log INFO my-test-prefix:msg info',
                 'log DEBUG my-test-prefix:msg debug',
                 'log WARNING my-test-prefix:msg warn',
                 'log ERROR my-test-prefix:msg err',
                 'endOfList'
                ])
        self.assertEqual(self.iface.ITEMS,
                        [PFolder(label=u'Kočka'),
                         PFolder(label='bb')
                        ])
        self.assertEqual( self.iface.ITEMS[1].menuItems,
                            [('label', 'action')] )


    def test_myGen(self):
        self.plugin.call('myGen')
        self.assertEqual(self.iface.LOG,
                ['setSorting None',
                 'endOfList'
                ])
        self.assertEqual(self.iface.ITEMS,
                        [PItem(label='x'),
                         PItem(label='y'),
                        ])


    def test_empty(self):
        self.plugin.call('empty')
        self.assertEqual(self.iface.LOG, ['endOfList'])


    def test_cancel(self):
        self.plugin.call('cancel')
        self.assertEqual(self.iface.LOG, ['cancelOperation'])
        self.assertEqual(self.iface.ITEMS, [PItem(label='1')] )


    def test_play(self):
        self.plugin.call('p1', url='asdx', info='x7')
        self.assertEqual(self.iface.LOG, [('play', 'asdx', 'x7', None)])


    def test_okDialog(self):
        self.plugin.call('okdialog')
        self.assertEqual(self.iface.ITEMS, [PItem(label='cancel')])

        self.iface.cleanup()
        callArgs = []
        def cb(*a):
            callArgs.append(a)
            return True
        self.iface.dialogCallback['okDialog'] = cb
        self.plugin.call('okdialog')
        self.assertEqual(self.iface.ITEMS, [PItem(label='ok')])
        self.assertEqual( callArgs, [('Cancel test', 'L1', 'LL2', 'LLL3')] )

        self.iface.cleanup()
        callArgs = []
        self.iface.dialogCallback['okDialog'] = lambda *a: False
        self.plugin.call('okdialog')
        self.assertEqual(self.iface.ITEMS, [PItem(label='cancel')])


    def test_textDialog(self):
        self.plugin.call('textdialog')
        self.assertEqual(self.iface.ITEMS, [PItem(label='NONE')])

        self.iface.cleanup()
        callArgs = []
        def cb(*a):
            callArgs.append(a)
            return 'entered text'
        self.iface.dialogCallback['textDialog'] = cb
        self.plugin.call('textdialog')
        self.assertEqual(self.iface.ITEMS, [PItem(label='entered text')])
        self.assertEqual( callArgs, [('head', 'dflt', False)] )

        self.iface.cleanup()
        callArgs = []
        self.iface.dialogCallback['textDialog'] = lambda *a: ''
        self.plugin.call('textdialog')
        self.assertEqual(self.iface.ITEMS, [PItem(label='')])


    def test_attrs(self):
        self.plugin.core.totalItems = 77
        self.plugin.core.updateListing = 12
        self.plugin.core.cacheToDisc = 41

        self.assertEqual(self.iface.totalItems, 77)
        self.assertEqual(self.iface.updateListing, 12)
        self.assertEqual(self.iface.cacheToDisc, 41)

        self.iface.cleanup()
        self.assertEqual(self.iface.totalItems, 0)
        self.assertEqual(self.iface.updateListing, False)
        self.assertEqual(self.iface.cacheToDisc, False)


    def test_execute(self):
        self.iface.execute('bla X ert')
        self.assertEqual( self.iface.LOG, ["execute 'bla X ert'"] )


    def test_no_call(self):
        try:
            self.plugin.call('no_call')
        except Exception, e:
            self.assertTrue("MyPlugin has not plugin_call 'no_call'" in str(e))
        else:
            self.assertTrue(0)



if __name__ == '__main__':
    plugintest.main()

