""" Test class for Plugin Interface """
__all__ = ["TestPluginInterface"]

import urllib


class TestPluginInterface:
    """ Testing PluginInterface class for plugins based on BasePlugin """
    baseurl = '<baseurl>'
    SETTINGS = {}

    def __init__(self):
        """ Constructor """
        self.cleanup()

    def cleanup(self):
        self.LOG = []
        self.SETTINGS = {}
        self.ITEMS = []
        self.totalItems = 0
        self.updateListing = False
        self.cacheToDisc = False
        self.dialogCallback = {}
        self.PATH = {}


    def getCallParams(self, call=None, **params):
        return (call, params)

    def generateURL(self, _item=None, **params):
        if _item:
            if _item.path and not _item.call:
                return _item.path
            params['call'] = _item.call
            params.update( _item.param )
        return self.baseurl + '?' + urllib.urlencode(params)

    def setSorting(self, key):
        self.LOG.append('setSorting %s' % key)

    def addItem(self, item):
        self.ITEMS.append(item)

    def endOfList(self):
        self.LOG.append('endOfList')

    def cancelOperation(self):
        self.LOG.append('cancelOperation')

    def getSetting(self, key):
        return self.SETTINGS.get(key)

    def setSetting(self, key, value):
        self.SETTINGS[key] = value

    def play(self, url, item=None, subtitles=None):
        self.LOG.append(('play', url, item, subtitles))

    def log(self, message, level):
        self.LOG.append('log %s %s' % (level, message))

    def getLocalizedString(self, id):
        return "LocStr#"+id

    def translatePath(self, path):
        result = self.PATH.get(path)
        if not result:
            raise Exception('You must defined self.PATH[%r]' % path)
        return result

    def execute(self, command):
        return self.LOG.append('execute '+repr(command))

    def okDialog(self, heading, line1, line2=None, line3=None):
        msg = 'okDialog heading=%r line1=%r' % (heading, line1)
        if line2:
            msg += 'line2='+repr(line2)
        if line3:
            msg += 'line2='+repr(line3)
        self.LOG.append(msg)
        callback = self.dialogCallback.get('okDialog')
        if callback:
            return callback(heading, line1, line2, line3)
        return None

    def textDialog(self, heading='', default='', hidden=False):
        self.LOG.append('textDialog heading=%r default=%r hidden=%r' \
                            % (heading, default, hidden) )
        callback = self.dialogCallback.get('textDialog')
        if callback:
            return callback(heading, default, hidden)
        return None


    # Progress dialog methods

    def newProgress(self, heading, line1, line2=None, line3=None):
        pass

    def updateProgress(self, percent, line1=None, line2=None, line3=None):
        pass

    def closeProgress(self):
        pass

