# -*- encoding: utf-8 -*-

import plugintest
from streamczPlugin import *


class TestStreamCZPlugin(plugintest.PluginTestCase):
    PLUGIN_CLASS = StreamCZPlugin


    def setUp(self):
        plugintest.PluginTestCase.setUp(self)
        self.iface.SETTINGS = {
                    'video_quality': 0,
                    'search_order': 0,
                    'max_saved_count': 0,
                }


    def test_root(self):
        self.plugin.call()

        self.assertEqual( len(self.iface.ITEMS), 5 )

        self.assertPItemMatches(self.iface.ITEMS[0],
                    label = u'Hledat video',
                    call = 'search',
                    isFolder = True)

        self.assertPItemMatches(self.iface.ITEMS[1],
                    label = u'Televize',
                    call = 'list_televize',
                    isFolder = True)

        self.assertPItemMatches(self.iface.ITEMS[2],
                    label = u'Uživatelská videa',
                    call = 'list_categories',
                    param = {'path': '/kategorie/2-uzivatelska-videa'},
                    isFolder = True)

        self.assertPItemMatches(self.iface.ITEMS[3],
                    label = u'Hudba',
                    call = 'list_hudba',
                    isFolder = True)

        self.assertPItemMatches(self.iface.ITEMS[4],
                    label = u'Témata',
                    call = 'list_categories',
                    param = {'path': '/tema'},
                    isFolder = True)


    def test_list_televize(self):
        self.plugin.call('list_televize')

        self.assertTrue( len(self.iface.ITEMS) > 5 )

        self.assertPItemMatches(self.iface.ITEMS[0],
                    label = u'Vše',
                    call = 'list_tv_channel',
                    param = {'path': '/televize'},
                    isFolder = True)

        self.assertPItemMatches(self.iface.ITEMS[1],
                    label = u'Stream',
                    call = 'list_tv_channel',
                    param = {'path': '/televize/429-stream'},
                    isFolder = True)

        self.assertPItemMatches(self.iface.ITEMS[-1],
                    label = u'Public TV',
                    call = 'list_tv_channel',
                    param = {'path': '/televize/348-public-tv'},
                    isFolder = True)

 
    def test_list_tv_channel_with_subitems(self):
        self.plugin.call('list_tv_channel', path='/televize/429-stream')

        self.assertTrue( len(self.iface.ITEMS) > 5 )
        self.assertPItemMatches(self.iface.ITEMS[0],
                label=u'Vše',
                call='list_videos',
                param={'path': '/televize/429-stream'},
                isFolder=True
            )

        item = self.assertPItemExists(label=u'Dostaň Agátu')
        self.assertPItemMatches(item,
                label=u'Dostaň Agátu',
                call='list_videos',
                param={'path': '/kategorie/379-dostan-agatu'},
                isFolder=True
            )


    def test_list_tv_channel_without_subitems(self):
        self.plugin.call('list_tv_channel', path='/televize/423-ceska-televize')

        self.assertTrue( len(self.iface.ITEMS) > 8 )
        self.assertPItemMatches(self.iface.ITEMS[0],
                call='play',
                isFolder=False
            )

        self.assertPItemMatches(self.iface.ITEMS[-1],
                label=u'<Další strana>',
                call='list_videos',
                isFolder=True
            )


    def test_list_hudba(self):
        self.plugin.call('list_hudba')
        self.assertEqual( len(self.iface.ITEMS), 4 )

        self.assertPItemMatches(self.iface.ITEMS[0],
                    label = u'TOP 20',
                    call = 'list_videos',
                    param = {'path': 'http://music.stream.cz/klipy/top20'},
                    isFolder = True)

        self.assertPItemMatches(self.iface.ITEMS[1],
                    label = u'Nejnovější klipy',
                    call = 'list_videos',
                    param = {'path': 'http://music.stream.cz/klipy/nejnovejsi'},
                    isFolder = True)

        self.assertPItemMatches(self.iface.ITEMS[2],
                    label = u'Seznam interpretů',
                    call = 'list_hudba_interprets',
                    isFolder = True)

        self.assertPItemMatches(self.iface.ITEMS[3],
                    label = u'Hudební videoarchiv',
                    call = 'list_videos',
                    param = {'path': 'http://music.stream.cz/porady/hudebni-videoarchiv'},
                    isFolder = True)


    def test_list_hudba_interprets(self):
        self.plugin.call('list_hudba_interprets')
        self.assertTrue( len(self.iface.ITEMS) > 50 )

        item = self.assertPItemExists(label=u'Divokej Bill')
        self.assertPItemMatches(item,
                call='list_videos',
                param={'path': 'http://music.stream.cz/interpret/100-divokej-bill'},
                isFolder=True
            )

        item = self.assertPItemExists(label=u'Xindl X')
        self.assertPItemMatches(item,
                call='list_videos',
                param={'path': 'http://music.stream.cz/interpret/8000-xindl-x'},
                isFolder=True
            )


    def test_list_categories(self):
        self.plugin.call('list_categories', path='/kategorie/2-uzivatelska-videa')
        
        self.assertTrue( len(self.iface.ITEMS) > 5 )
        self.assertPItemMatches(self.iface.ITEMS[0],
                label=u'Vše',
                call='list_videos',
                param={'path': '/kategorie/2-uzivatelska-videa'},
                isFolder=True
            )

        item = self.assertPItemExists(label=u'Sport')
        self.assertPItemMatches(item,
                label=u'Sport',
                call='list_videos',
                param={'path': 'http://www.stream.cz/kategorie/10-sport'},
                isFolder=True
            )


    def test_list_videos_alles_gute(self):
        self.plugin.call('list_videos', path='/kategorie/179-alles-gute')
        self.assertTrue( self.iface.ITEMS > 10 )

        item = self.assertPItemExists(label=u'Alles Gute: Gipsy.cz útočí')
        self.assertPItemMatches(item,
                label = u'Alles Gute: Gipsy.cz útočí',
                call = 'play',
                param = {'path':  'http://www.stream.cz/video/263193-alles-gute-gipsy-cz-utoci'},
                info = {'plot': re.compile(u'lekce Alles Gute když', re.U) },
                iconURL = re.compile('^http://.*stream.cz/'),
                isFolder = False
            )

        item = self.assertPItemExists(label=u'Alles Gute: První noc v holobytě')
        self.assertPItemMatches(item,
                label = u'Alles Gute: První noc v holobytě',
                call = 'play',
                param = {'path':  'http://www.stream.cz/video/263176-alles-gute-prvni-noc-v-holobyte'},
                info = {'plot': re.compile(u'Legendy Egon a Karl se vrací v oslnivé formě', re.U) },
                iconURL = re.compile('^http://.*stream.cz/'),
                isFolder = False
            )
        
        self.assertPItemMatches(self.iface.ITEMS[-1],
                label=u'<Další strana>',
                call='list_videos',
                param={'path': u'http://www.stream.cz/?&a=category&m=video&category_id=179&page=9'},
                isFolder = True
            )


    def test_list_videos_uzivatelska_videa(self):
        self.plugin.call('list_videos', path='/kategorie/2-uzivatelska-videa')
        self.assertTrue( self.iface.ITEMS > 5 )
        self.assertPItemMatches(self.iface.ITEMS[0],
                call='play',
                param={'path': re.compile('/video/.*')},
                info = {'plot': re.compile(u'.*', re.U) },
                iconURL = re.compile('^http://.*stream.cz/'),
                isFolder = False
            )

        self.assertPItemMatches(self.iface.ITEMS[-1],
                label=u'<Další strana>',
                call='list_videos',
                param={'path': re.compile('&a=category&m=video&category_id=2&page=')},
                isFolder = True
            )


    def test_list_videos_tema(self):
        self.plugin.call('list_videos', path='/tema')
        self.assertTrue( self.iface.ITEMS > 10 )

        self.assertPItemMatches(self.iface.ITEMS[0],
                call = 'play',
                param = {'path':  re.compile('^http://www.stream.cz/video/\d+')},
                iconURL = re.compile('^http://.*stream.cz/'),
                isFolder = False
            )

        self.assertPItemMatches(self.iface.ITEMS[-1],
                label=u'<Další strana>',
                call='list_videos',
                param={'path': u'http://www.stream.cz/?&a=theme_videolist&m=video&page=10'},
                isFolder = True
            )


    def test_list_videos_klipy_nejnovejsi(self):
        self.plugin.call('list_videos', path='http://music.stream.cz/klipy/nejnovejsi')
        self.assertTrue( len(self.iface.ITEMS) > 5 )
        self.assertPItemMatches(self.iface.ITEMS[0],
                call='play',
                param={'path': re.compile('^http://music.stream.cz/.*')},
                info = {'plot': re.compile(u'.*', re.U) },
                iconURL = re.compile('^http://.*stream.cz/'),
                isFolder = False
            )

        self.assertPItemMatches(self.iface.ITEMS[-1],
                label=u'<Další strana>',
                call='list_videos',
                param={'path': 'http://music.stream.cz/klipy/nejnovejsi?o=&p=1'},
                isFolder = True
            )


    def test_search(self):
        self.plugin.call('search')

        self.assertEqual( self.iface.ITEMS, [
                    PFolder(label=u'<Nové hledání>', call='new_search')
                ])

        self.iface.cleanup()
        self.iface.SETTINGS['saved_list'] = '3x as\nt2x'
        self.plugin.call('search')
        self.assertEqual( self.iface.ITEMS, [
                    PFolder(label=u'<Nové hledání>', call='new_search'),
                    PFolder(label='3x as', call='search_result',
                                    param={'qtext': '3x as'}),
                    PFolder(label='t2x', call='search_result',
                                    param={'qtext': 't2x'}),
                ])
        self.assertEqual( self.iface.ITEMS[1].menuItems,
                            [('Vymazat', 'XBMC.RunPlugin(<baseurl>?qtext=3x+as&call=delete_search)')] )
        self.assertEqual( self.iface.ITEMS[2].menuItems,
                            [('Vymazat', 'XBMC.RunPlugin(<baseurl>?qtext=t2x&call=delete_search)')] )


    def test_search_result(self):
        self.iface.SETTINGS = {
                    'search_order': 0,
                    'saved_list': 'some text',
                    'max_saved_count': 0,
                }
        self.plugin.call('search_result', qtext='inbox', page='15')
        self.assertTrue(len(self.iface.ITEMS) > 10)

        self.assertEqual(self.iface.ITEMS[0].label, u'<Další stránka>')
        self.assertEqual(self.iface.ITEMS[0].call, 'search_result')
        self.assertEqual(self.iface.ITEMS[0].param,
                            {'qtext': 'inbox', 'page': '30'})
        self.assertEqual(self.iface.ITEMS[0].isFolder, True)

        self.assertTrue(self.iface.ITEMS[1].label)
        self.assertTrue(self.iface.ITEMS[1].info.get('plot'))
        self.assertEqual(self.iface.ITEMS[1].call, 'play')
        self.assertTrue(self.iface.ITEMS[1].param['path'].startswith('/video/'))
        self.assertEqual(self.iface.ITEMS[1].isFolder, False)

        self.assertEqual( self.iface.SETTINGS['saved_list'],
                            'inbox\nsome text' )


    def test_search_result_empty(self):
        self.iface.SETTINGS = {
                    'search_order': 0,
                    'saved_list': 't1\nt2',
                    'max_saved_count': 0,
                }
        self.plugin.call('search_result', qtext='asjh3jthahekajsdkafs')
        self.assertEqual(self.iface.ITEMS, [])
        self.assertEqual( self.iface.SETTINGS['saved_list'],
                            't1\nt2' )


    def test_new_search(self):
        self.plugin.call('new_search')
        self.assertEqual(self.iface.LOG[-1], "cancelOperation")

        self.iface.cleanup()
        def cb(*a):
            self.assertEqual(a, ('Search videos', '', False))
            return 'entTXT'
        self.iface.dialogCallback['textDialog'] = cb

        self.plugin.call('new_search')
        self.assertEqual(self.iface.LOG[-1],
                "execute 'Container.Update(<baseurl>?qtext=entTXT&call=search_result)'")


    def test_play_base(self):
        self.plugin.call('play', path='/video/108/2984-30-dni-nemyte-vlasy-dil-5/?word_id=28004')
        self.assertEqual( self.iface.LOG[-1][0], 'play' )
        self.assertEqual( self.iface.LOG[-1][1], 'http://cdn-dispatcher.stream.cz/?id=2578' )

        item = self.iface.LOG[-1][2]
        self.assertEqual( item.label, u'30 dní nemyté vlasy - Díl 5' )
        self.assertTrue( item.info.get('plot') )


    def test_play_cdnHQ(self):
        self.plugin.call('play', path='/video/263193-alles-gute-gipsy-cz-utoci')
        self.assertEqual( self.iface.LOG[-1][0], 'play' )
        self.assertEqual( self.iface.LOG[-1][1], 'http://cdn-dispatcher.stream.cz/?id=178742' )

        item = self.iface.LOG[-1][2]
        self.assertEqual( item.label, u'Alles Gute: Gipsy.cz útočí' )
        self.assertTrue( item.info.get('plot') )


    def test_play_prima(self):
        self.plugin.call('play', path='/video/215/393349-ano-sefe-ii-11/?word_id=23')
        self.assertEqual( self.iface.LOG[-1][0], 'play' )
        self.assertEqual( self.iface.LOG[-1][1], 'http://cdn-dispatcher.stream.cz/?id=354698' )

        item = self.iface.LOG[-1][2]
        self.assertEqual( item.label, u'Ano, šéfe! II (11)' )
        self.assertTrue( item.info.get('plot') )


    def test_play_ocko(self):
        self.plugin.call('play', path='/video/347/384644-inbox-horkyze-slize/?word_id=974')
        self.assertEqual( self.iface.LOG[-1][0], 'play' )
        self.assertEqual( self.iface.LOG[-1][1], 'http://cdn-dispatcher.stream.cz/?id=338331' )

        item = self.iface.LOG[-1][2]
        self.assertEqual( item.label, u'Inbox: Horkýže slíže' )
        self.assertTrue( item.info.get('plot') )


    def test_play_o2(self):
        self.plugin.call('play', path='http://www.o2.music.stream.cz/klip/235900-abc-that-was-then-but-this-is-now')
        self.assertEqual( self.iface.LOG[-1][0], 'play' )
        self.assertEqual( self.iface.LOG[-1][1], 'http://cdn-dispatcher.stream.cz/?id=163158' )

        item = self.iface.LOG[-1][2]
        self.assertEqual( item.label, u'ABC:That Was Then But This Is Now' )
        #self.assertTrue( item.info.get('plot') )


    def test_delete_search(self):
        self.plugin.call('delete_search', qtext='asd')
        self.assertEqual( self.iface.SETTINGS.get('saved_list'), None )
        self.assertEqual( self.iface.LOG[-1], "execute 'Container.Refresh'" )

        self.iface.cleanup()
        self.iface.SETTINGS['saved_list'] = 'jas3\nasd x\nas'
        self.plugin.call('delete_search', qtext='asd x')
        self.assertEqual( self.iface.SETTINGS['saved_list'], 'jas3\nas' )
        self.assertEqual( self.iface.LOG[-1], "execute 'Container.Refresh'" )

        self.iface.cleanup()
        self.iface.SETTINGS['saved_list'] = 'jas3\nasd x\nas'
        self.plugin.call('delete_search', qtext='asd')
        self.assertEqual( self.iface.SETTINGS['saved_list'], 'jas3\nasd x\nas' )
        self.assertEqual( self.iface.LOG[-1], "execute 'Container.Refresh'" )


    def test_get_cdn_id(self):
        content1 = ' my data cdnHQ=7998 cdnLQ=10751 end'
        content2 = ' my data cdnLQ=10752 cdnHQ=7999 end'
        content_old = 'my data&cdnID=1338&xxx'
        content_not_found = 'asdasdadsdassdadasda'

        self.iface.SETTINGS['video_quality'] = 0 # HQ
        self.assertEqual( self.plugin.get_cdn_id(content1), 7998 )
        self.assertEqual( self.plugin.get_cdn_id(content2), 7999 )
        self.assertEqual( self.plugin.get_cdn_id(content_old), 1338 )
        self.assertEqual( self.plugin.get_cdn_id(content_not_found), None )

        self.iface.SETTINGS['video_quality'] = 1 # LQ
        self.assertEqual( self.plugin.get_cdn_id(content1), 10751 )
        self.assertEqual( self.plugin.get_cdn_id(content2), 10752 )
        self.assertEqual( self.plugin.get_cdn_id(content_old), 1338 )
        self.assertEqual( self.plugin.get_cdn_id(content_not_found), None )


    def test_get_saved_searches(self):
        self.assertEqual( self.plugin.get_saved_searches(), [] )

        self.iface.SETTINGS['saved_list'] = 'asd\nxxaax\n1'
        self.assertEqual( self.plugin.get_saved_searches(), ['asd', 'xxaax', '1'] )


    def test_set_saved_searches(self):
        self.plugin.set_saved_searches(['as', '7as dd'])
        self.assertEqual( self.iface.SETTINGS['saved_list'], 'as\n7as dd' )


    def test_save_search(self):
        self.iface.SETTINGS = {'saved_list': 'asx', 'max_saved_count': 0}
        self.plugin.save_search('slsa')
        self.assertEqual(self.iface.SETTINGS['saved_list'], 'slsa\nasx')

        self.plugin.save_search('slsa')
        self.assertEqual(self.iface.SETTINGS['saved_list'], 'slsa\nasx')

        self.plugin.save_search('112')
        self.assertEqual(self.iface.SETTINGS['saved_list'], '112\nslsa\nasx')

        self.plugin.save_search('slsa')
        self.assertEqual(self.iface.SETTINGS['saved_list'], '112\nslsa\nasx')


    def test_full_link_to(self):
        self.plugin.wget.request_url = 'http://my.base.url/aaa/bbb/ccc?a=5foo=bar'

        self.assertEqual( self.plugin.full_link_to('http://example.org/abc'),
                            'http://example.org/abc' )
        self.assertEqual( self.plugin.full_link_to('/abc1'),
                            'http://my.base.url/abc1' )
        self.assertEqual( self.plugin.full_link_to('abc1'),
                            'http://my.base.url/aaa/bbb/abc1' )
        self.assertEqual( self.plugin.full_link_to('../abc1?a=8'),
                            'http://my.base.url/aaa/abc1?a=8' )
        self.assertEqual( self.plugin.full_link_to('?w=7'),
                            'http://my.base.url/aaa/bbb/ccc?w=7' )


if __name__ == '__main__':
    plugintest.main()

